﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ObiegowkiLista.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.ObiegowkiLista" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Obiegówki</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataOdRaport').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDoRaport').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });

            $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataOdRaport").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDoRaport").datepicker("option", "dateFormat", 'yy-mm-dd');

            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });
            $("#btnRaport").button({ icons: { primary: 'ui-icon-print' } });
            $("#btnRaportAnuluj").button({ icons: { primary: 'ui-icon-cancel' } });
            $("#btnRaportWybierz").button({ icons: { primary: 'ui-icon-check' } });

            //w ff nie widać za bardzo że jest disabled więc ustawiamy z ręki
            if (!$("#btnRaport").attr('href')) {
                $("#btnRaport").addClass("ui-state-disabled");
            }

            $("#dialog-form").dialog({
                autoOpen: false,
                width: 400,
                modal: true,
                position: "top",
                resizable: false

            });
        });

        function OtworzOkienkoRaportu() {
            if ($("#btnRaport").attr('href')) {
                $("#dialog-form").parent().appendTo(jQuery("form:first"));
                $("#dialog-form").dialog("open");
            }
        }

        function ZamknijOkienkoRaportu(nr) {
            $("#dialog-form").dialog("close");
        }
    </script>
    <style type="text/css">
        .ui-datepicker SELECT.ui-datepicker-month-year {
            WIDTH: 100%;
        }

        .ui-datepicker SELECT.ui-datepicker-month {
            WIDTH: 35%;
        }

        .ui-datepicker SELECT.ui-datepicker-year {
            WIDTH: 35%;
        }
    </style>
</head>
<body id="body" style="font-size: 8pt;" runat="server">
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="5"><span style="font-size: 12pt; font-weight: bold">Obiegówki</span></td>
                </tr>
                <tr>
                    <td colspan="2" style="width: 25%" valign="bottom">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="95%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="2" style="width: 30%" valign="bottom">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="1" style="text-align: right" valign="bottom">
                        <a id="btnRaport" runat="server" style="width: 90px;" class="aspButton" href="javascript:OtworzOkienkoRaportu();" visible="False">Obiegówki przetermin.</a>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%" valign="bottom">
                        <small>Jednostka</small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="100%"></asp:DropDownList>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>od (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataOd" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>do (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataDo" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 30%" valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus" Width="100%" runat="server">
                            <asp:ListItem Value="0">-Wybierz status-</asp:ListItem>
                            <asp:ListItem Value="DZ" Selected="True">Do zatwierdzenia</asp:ListItem>
                            <asp:ListItem Value="NZ">Nie zatwierdzone</asp:ListItem>
                            <asp:ListItem Value="WPR">Wygenerowana</asp:ListItem>
                            <asp:ListItem Value="OCK">Oczekująca na zatwierdzenie</asp:ListItem>
                            <asp:ListItem Value="ZAT">Zatwierdzona</asp:ListItem>
                            <asp:ListItem Value="ANU">Anulowana</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td style="width: 15%; text-align: right" valign="bottom">
                        <small></small>
                        <br />
                        <asp:LinkButton ID="btnOdswiez" runat="server" Text="Odśwież" Width="90px" CssClass="aspButton" OnClick="btnOdswiez_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_OBIEGOWKI,STATUS,IMIE,NAZWISKO,JEDNOSTKA,STANOWISKO,ID_KTH_ALT,DATA_ROZWIAZANIA,SPECYFIKACJA_EMAIL" OnRowCommand="gvListy_RowCommand" AllowPaging="True">
                <Columns>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
                    <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
                    <asp:BoundField DataField="ID_KONTRAHENTA" HeaderText="Id kontrahenta(CSK)" SortExpression="ID_KONTRAHENTA" />
                    <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                    <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                    <asp:BoundField DataField="RODZAJ_UMOWY" HeaderText="Rodzaj Umowy" SortExpression="RODZAJ_UMOWY" />
                    <asp:BoundField DataField="DATA_ROZWIAZANIA" HeaderText="Data zakończenia" DataFormatString="{0:yyyy-MM-dd}" SortExpression="DATA_ROZWIAZANIA" />
                    <asp:BoundField DataField="DATA_UTWORZENIA" HeaderText="Data wygenerowania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_UTWORZENIA" />
                    <asp:BoundField DataField="DATA_ZATWIERDZENIA" HeaderText="Data zatwierdzenia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ZATWIERDZENIA" />
                    <asp:BoundField DataField="ZATWIERDZAJACY" HeaderText="Zatwierdzający" SortExpression="ZATWIERDZAJACY" />
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="OBIEGOWKI_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected">
                <SelectParameters>
                    <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                    <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbDataOd" Name="P_DATA_OD" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="tbDataDo" Name="P_DATA_DO" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue"
                        Type="String" />
                    <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
        <!-- Okienko dialogu -->
        <div id="dialog-form" title="Obiegówki przeterminowane, nie zatwierdzone">
            <div style="width: 100%;">
                <small>Jednostka</small><br />
                <asp:DropDownList ID="ddlJednostkiRaport" runat="server" Width="100%">
                </asp:DropDownList><br />
                <small>Od (rrrr-mm-dd)</small><br />
                <asp:TextBox ID="tbDataOdRaport" runat="server"></asp:TextBox><br />
                <small>Do (rrrr-mm-dd)</small><br />
                <asp:TextBox ID="tbDataDoRaport" runat="server"></asp:TextBox><br />
                <asp:CheckBox ID="cbPrzeterminowane" runat="server" Checked="True" Text="Przeterminowane" />
            </div>
            <div style="height: 5px;">
                &nbsp;
            </div>
            <div>
                <div style="float: right;">
                    <asp:LinkButton ID="btnRaportWybierz" runat="server" Text="Wybierz" OnClick="btnRaportWybierz_Click" />
                    <a id="btnRaportAnuluj" href="javascript:ZamknijOkienkoRaportu()">Anuluj</a>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
